﻿WITH   RECURSIVE  graphe_ville (ville_deb,ville_fin,cp_deb,cp_fin,distance) AS (
VALUES ('PARIS','NANTES','75000','44000',385),('PARIS','CLERMONT-FERRAND', '75000','63000',420),
       ('PARIS','LYON','75000','69000',470),('CLERMONT-FERRAND','MONTPELLIER','63000','34000',335),
       ('CLERMONT-FERRAND','TOULOUSE','63000','31000',375),('LYON','MONTPELLIER','69000','34000',305),
       ('LYON','MARSEILLE','69000','13000',320),('MONTPELLIER','TOULOUSE','34000','31000',240),
       ('MARSEILLE','NICE','13000','06000',205),('NANTES','BORDEAUX','44000','33000',335),
       ('BORDEAUX','TOULOUSE','33000','31000',245),('MARSEILLE','MONTPELLIER','13000','34000',170)),
       voyage(ville_depart,cp_depart,ville_arrivee,cp_arrivee) AS (
VALUES ('PARIS','75000','TOULOUSE','31000')),	
       graphe_croise (ville_deb,ville_fin,cp_deb,cp_fin,distance)  AS (
SELECT ville_deb,ville_fin,cp_deb,cp_fin,distance FROM graphe_ville 
	-- Pour avoir les distances entre deux villes dans les 2 sens (sens de graphe_ville et sens opposé)
UNION  ALL
SELECT ville_fin,ville_deb,cp_fin,cp_deb,distance FROM graphe_ville), --  Sens opposé  
       dijkstra (ville_arrivee,cp_fin, nb_etapes, distance, etapes) AS (
                -- Implémentation de l'algorithme de Dijkstra
SELECT DISTINCT ville_deb,cp_deb, 0, 0, ville_deb||'('||cp_deb||')' 
FROM   graphe_croise CROSS JOIN voyage
WHERE  ville_deb = ville_depart AND cp_deb=cp_depart
UNION  ALL
SELECT arrivee.ville_fin,arrivee.cp_fin, depart.nb_etapes + 1,depart.distance + arrivee.distance,
       depart.etapes||','|| arrivee.ville_fin||'('||arrivee.cp_fin||')'
FROM   graphe_croise AS arrivee INNER JOIN dijkstra AS depart 
       ON depart.ville_arrivee = arrivee.ville_deb AND depart.cp_fin=arrivee.cp_deb
WHERE  depart.etapes NOT LIKE '%'||arrivee.ville_fin||'('||arrivee.cp_fin||')%')
       -- Evite les boucles : ne pas déjà avoir la ville dans la liste des étapes 
SELECT  nb_etapes AS "Nb d'étapes",dijkstra.distance AS "Distance",etapes AS "Liste des étapes"
FROM    dijkstra CROSS JOIN voyage
WHERE   dijkstra.ville_arrivee = voyage.ville_arrivee AND cp_fin=voyage.cp_arrivee
ORDER   BY dijkstra.distance;
